const express = require('express');
const http = require('http');
const cors = require('cors');
const { Server } = require('socket.io');

const app = express();
const server = http.createServer(app);
const io = new Server(server, {
  cors: {
    origin: '*', // allow all for dev, restrict in production
    methods: ['GET', 'POST'],
  },
});

app.use(cors());
app.use(express.json());

app.post('/api/track', (req, res) => {
  const { latitude, longitude, deviceId } = req.body;
  console.log('Received location:', { latitude, longitude, deviceId });

  // Emit data to all connected socket.io clients
  io.emit('location-update', { latitude, longitude, deviceId });

  res.status(200).json({ success: true });
});

server.listen(3000, () => {
  console.log('Server listening on http://localhost:3000');
});
